$!
$! This command file sets up DCL symbols for commonly-used tools.
$!
$! This procedure determines which images are needed for the current
$! system architecture (VAX or Alpha), and sets up the symbols...
$!
$! Some tools are from OpenVMS freeware CD 5.0 as well as some GNU executables
$! another as make, diff have been built by Zoltan Arpadffy to make Vim under
$! OpenVMS more easier to use.
$!
$! GNU tools archive for Vim is downloadable from
$! http://www.polarfox.com/vim/
$!
$! There might be problems with SHR images or OpenVMS versions. 
$! These executables come without any support. Use them at own risk.
$! 
$ Arch       = f$getsyi("ARCH_NAME")
$ Device     = f$parse(f$environment("PROCEDURE"),,,"DEVICE")
$ Direct     = f$parse(f$environment("PROCEDURE"),,,"DIRECTORY")
$ Direct     = Direct - "][" - "><" - ">" - "<" - "]" - "["
$ DevDir     = Device + "[" + Direct + "]"
$ DevDirArch = Device + "[" + Direct + "." + Arch + "]"
$
$ BZIP       :== $'DevDirArch'BZIP2.exe     
$ D64        :== $'DevDirArch'DECODE_64.exe
$ DIFF       :== $'DevDirArch'DIFF.EXE
$ GAWK       :== $'DevDirArch'GAWK.EXE	
$ GUNZIP     :== $'DevDirArch'GUNZIP.EXE
$ GZIP       :== $'DevDirArch'GZIP.exe    
$ MAKE       :== $'DevDirArch'MAKE.EXE
$ PATCH      :== $'DevDirArch'PATCH.EXE
$ SED        :== $'DevDirArch'SED.EXE
$ TAR        :== $'DevDirArch'TAR.EXE
$ UNZI*P     :== $'DevDirArch'UNZIP.exe  
$ UUDE*CODE  :== $'DevDirArch'UUDECODE.exe
$ UUEN*CODE  :== $'DevDirArch'UUENCODE.exe
$ VMST*AR    :== $'DevDirArch'VMSTAR.exe 
$ ZCAT       :== $'DevDirArch'ZCAT.EXE
$ ZIP        :== $'DevDirArch'ZIP.exe   
$
$ Exit
